from django.db import models

class student(models.Model):
    sno=models.AutoField(primary_key=True)
    fullname=models.CharField(max_length=40)
    branch=models.CharField(max_length=50)
    enrollment=models.CharField(max_length=16)
    emailid=models.CharField(unique=True,max_length=45)
    dob=models.DateField()
    mobile=models.BigIntegerField()
    pwd=models.CharField(max_length=13)
    role=models.CharField(max_length=15)

    class Meta:
        db_table = 'tnpproject_student'

class internship(models.Model):
    internshipname=models.CharField(max_length=100)
    internshiporg=models.CharField(max_length=100)
    internshipdesc=models.CharField(max_length=200)
    internshiploc=models.CharField(max_length=100)
    internshipsti=models.CharField(max_length=50)
    internshipdur=models.CharField(max_length=50)
    internshiplstd=models.DateField()

    class Meta:
        db_table = 'tnpproject_internship'
    
    def __str__(self):
        return self.internshipname

class events(models.Model):
    eventdate=models.DateField()
    eventname=models.CharField(max_length=50)
    eventloc=models.CharField(max_length=100)
    eventdur=models.TimeField() 
    eventyear=models.CharField(max_length=50)
    eventbranch=models.CharField(max_length=50)
    eventdesc=models.CharField(max_length=150)

    class Meta:
        db_table = 'tnpproject_events'


class training(models.Model):
    trainingprogram=models.CharField(max_length=50)
    trainingtrainer=models.CharField(max_length=50)
    trainingduration=models.CharField(max_length=100)


class internshipapplicants(models.Model):
    internship = models.ForeignKey(
        internship,
        on_delete=models.CASCADE,
        related_name="applicants",
        null=True,
        blank=True,
        db_constraint=False
    )

    applicantsname = models.CharField(max_length=100)
    applicantsemail = models.EmailField()
    applicantscontact = models.BigIntegerField()
    applicantsyear = models.CharField(max_length=50)
    applicantscourse = models.CharField(max_length=50)
    applicantsbranch = models.CharField(max_length=50)

    applicantsresume = models.FileField(
        upload_to="applicantsresume/",
        null=True,
        blank=True
    )

    applicantslinkedin = models.URLField()
    applicantsgithub = models.URLField()

    def __str__(self):
        return self.applicantsname


    

    


