from django.contrib import admin
from django.urls import path
from . import views
from django.conf import settings
from django.conf.urls.static import static


urlpatterns = [
    # Django Admin
    path('admin/', admin.site.urls),

    # Public pages
    path('', views.home, name='home'),
    path('registration/', views.register, name='registration'),
    path('login/', views.login, name='login'),
    #path('internship/', views.internship, name='internship'),
    #path('event/', views.event, name='event'),

    # Admin pages
    path('adminhome/', views.adminhome, name='adminhome'),
    path('adminevents/', views.adminevents, name='adminevents'),
    path('admininternships/', views.admininternships, name='admininternships'),
    path('admintraining/', views.admintraining, name='admintraining'),
    path('adminplacements/', views.adminplacements, name='adminplacements'),
    path('tnpint/', views.tnpint, name='tnpint'),
    path('tnpeve/', views.tnpeve, name='tnpeve'),
    path('tnptra/', views.tnptra, name='tnptra'),
    path('tnppla/', views.tnppla, name='tnppla'),
    path('tnpiic/', views.tnpint, name='tnpiic'),

    # 🔥 AJAX API (NEW – IMPORTANT)
    path('save-internship/', views.save_internship, name='save_internship'),
    path('get-internships/', views.get_internships, name='get_internships'),
    path("update-internship/<int:iid>/", views.update_internship, name="update_internship"),
    path("delete-internship/<int:iid>/", views.delete_internship, name="delete_internship"),
    path("apply-internship/<int:internship_id>/", views.apply_internship),
    path(
    "admin-internship-applicants/<int:internship_id>/",
    views.admin_internship_applicants,
    name="admin_internship_applicants"
),



    #================================================================================
    path("get-events/", views.get_events),
    path("save-event/", views.save_event),
    path("update-event/<int:eid>/", views.update_event),
    path("delete-event/<int:eid>/", views.delete_event),
    
    #Logout
    path('logout/', views.logout_view, name='logout'),

]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
