import json
from django.shortcuts import render, redirect
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from . import models
from .models import internship
from .models import events
from.models import internshipapplicants
from collections import defaultdict
from datetime import datetime
from django.contrib.auth import logout as dj_logout

# ===================== STUDENT REGISTRATION =====================

def register(request):
    if request.method == "GET":
        return render(request, "registration.html")
    else:
        fullname = request.POST.get("n")
        branch = request.POST.get("branch")
        enrollment = request.POST.get("rno")
        mobile = request.POST.get("mob")
        dob = request.POST.get("dob")
        emailid = request.POST.get("emailid")
        pwd = request.POST.get("pwd")
        role = "student"

        models.student.objects.create(
            fullname=fullname,
            branch=branch,
            enrollment=enrollment,
            mobile=mobile,
            dob=dob,
            emailid=emailid,
            pwd=pwd,
            role=role
        )

        return render(request, "registration.html")


# ===================== HOME =====================

def home(request):
    return render(request, "tnp.html")


# ===================== LOGIN =====================

def login(request):
    if request.method == "POST":
        emailid = request.POST.get("emailid")
        pwd = request.POST.get("pwd")

        result = models.student.objects.filter(emailid=emailid, pwd=pwd)

        if result.exists():
            role = result[0].role
            request.session["emailid"] = emailid
            request.session["role"] = role

            if role == "student":
                return redirect("/")
            elif role == "admin":
                return redirect("/adminhome/")
        else:
            return render(request, "login.html", {"error": "Invalid credentials"})

    return render(request, "login.html")


# ===================== INTERNSHIP PAGE (ADMIN UI) =====================

def admininternships(request):
    return render(request, "admininternships.html")


# ===================== SAVE INTERNSHIP (AJAX) =====================

@csrf_exempt
def save_internship(request):
    if request.method == "POST":
        data = request.POST

        obj = models.internship.objects.create(
            internshipname=data.get("internshipname"),
            internshiporg=data.get("internshiporg"),
            internshipdesc=data.get("internshipdesc"),
            internshiploc=data.get("internshiploc"),
            internshipsti=data.get("internshipsti"),
            internshipdur=data.get("internshipdur"),
            internshiplstd=data.get("internshiplstd"),
        )

        return JsonResponse({
            "id": obj.id,
            "internshipname": obj.internshipname,
            "internshiporg": obj.internshiporg,
            "internshiploc": obj.internshiploc,
            "internshipsti": obj.internshipsti,
            "internshipdur": obj.internshipdur,
            "internshiplstd": obj.internshiplstd,
        })

@csrf_exempt
def update_internship(request, iid):
    if request.method == "POST":
        obj = internship.objects.get(id=iid)

        obj.internshipname = request.POST.get("internshipname")
        obj.internshiporg = request.POST.get("internshiporg")
        obj.internshiploc = request.POST.get("internshiploc")
        obj.internshipsti = request.POST.get("internshipsti")
        obj.internshipdur = request.POST.get("internshipdur")
        obj.internshiplstd = request.POST.get("internshiplstd")
        obj.internshipdesc = request.POST.get("internshipdesc")

        obj.save()

        return JsonResponse({"status": "updated"})

@csrf_exempt
def delete_internship(request, iid):
    if request.method == "POST":
        internship.objects.filter(id=iid).delete()
        return JsonResponse({"status": "deleted"})

@csrf_exempt
def delete_event(request, eid):
    if request.method == "POST":
        events.objects.filter(id=eid).delete()
        return JsonResponse({"status": "deleted"})
# ===================== GET INTERNSHIPS (AJAX) =====================

def get_internships(request):
    data = list(
        internship.objects.values(
            "id",
            "internshipname",
            "internshiporg",
            "internshipdesc",
            "internshiploc",
            "internshipsti",
            "internshipdur",
            "internshiplstd"
        ).order_by("-id")
    )
    return JsonResponse(data, safe=False)

# ===================== EVENTS =====================

# def event(request):
#     if request.method == "GET":
#         return render(request, "tnpeve.html")
#     else:
#         models.events.objects.create(
#             eventdate=request.POST.get("eventdate"),
#             eventname=request.POST.get("eventname"),
#             eventloc=request.POST.get("eventloc"),
#             eventdur=request.POST.get("eventdur"),
#             eventyear=request.POST.get("eventyear"),
#             eventbranch=request.POST.get("eventbranch"),
#             eventdesc=request.POST.get("eventdesc")
#         )
#         return render(request, "tnpeve.html")


# ===================== ADMIN PAGES =====================

def adminhome(request):
    return render(request, "adminhome.html", {
        "event_count": events.objects.count(),
        "internship_count": internship.objects.count(),
        "training_count": 0,
        "placement_count": 0
    })

def adminevents(request):
    return render(request, "adminevents.html")

def admintraining(request):
    return render(request, "admintraining.html")

def adminplacements(request):
    return render(request, "adminplacements.html")

def tnpint(request):
    return render(request, "tnpint.html")

#====================== LOGOUT =====================
def logout_view(request):
    request.session.flush()   # clears session safely
    return redirect("/")

#=================USER=============================

def tnpeve(request):
     return render(request, "tnpeve.html")

def tnptra(request):
    return render(request, "tnptra.html")

def tnppla(request):
    return render(request, "tnppla.html")

def tnpiic(request):
    return render(request, "tnpiic.html")

#===============EVENTS==========================

# ================= GET EVENTS =================
def get_events(request):
    data = list(
        events.objects.values(
            "id",
            "eventname",
            "eventdate",
            "eventdur",
            "eventloc",
            "eventyear",
            "eventbranch",
            "eventdesc"
        )
    )
    return JsonResponse(data, safe=False)


# ================= ADD EVENT =================
@csrf_exempt
def save_event(request):
    if request.method == "POST":
        events.objects.create(
            eventname=request.POST.get("eventname"),
            eventdate=request.POST.get("eventdate"),
            eventdur=request.POST.get("eventdur"),
            eventloc=request.POST.get("eventloc"),
            eventyear=request.POST.get("eventyear"),
            eventbranch=request.POST.get("eventbranch"),
            eventdesc=request.POST.get("eventdesc")
        )
        return JsonResponse({"status": "saved"})


# ================= UPDATE EVENT =================
@csrf_exempt
def update_event(request, eid):
    if request.method == "POST":
        events.objects.filter(id=eid).update(
            eventname=request.POST.get("eventname"),
            eventdate=request.POST.get("eventdate"),
            eventdur=request.POST.get("eventdur"),
            eventloc=request.POST.get("eventloc"),
            eventyear=request.POST.get("eventyear"),
            eventbranch=request.POST.get("eventbranch"),
            eventdesc=request.POST.get("eventdesc")
        )
        return JsonResponse({"status": "updated"})


# ================= DELETE EVENT =================
@csrf_exempt
def delete_event(request, eid):
    if request.method == "POST":
        events.objects.filter(id=eid).delete()
        return JsonResponse({"status": "deleted"})

#================= APPLY FOR INTERNSHIP =================
def apply_internship(request, internship_id):
    if request.method != "POST":
        return JsonResponse({"error": "Invalid request"}, status=400)

    intern = internship.objects.get(id=internship_id)

    internshipapplicants.objects.create(
        internship=intern,   # ✅ THIS STORES internship_id
        applicantsname=request.POST.get("name"),
        applicantsemail=request.POST.get("email"),
        applicantscontact=request.POST.get("contact"),
        applicantsyear=request.POST.get("year"),
        applicantscourse=request.POST.get("course"),
        applicantsbranch=request.POST.get("branch"),
        applicantsresume=request.FILES.get("resume"),
        applicantslinkedin=request.POST.get("linkedin"),
        applicantsgithub=request.POST.get("github"),
    )

    return JsonResponse({"success": True})

#==================Get internship applicants ======================

def admin_internship_applicants(request, internship_id):
    applicants = internshipapplicants.objects.filter(internship_id=internship_id)

    data = []
    for a in applicants:
        data.append({
            "name": a.applicantsname,
            "email": a.applicantsemail,
            "contact": a.applicantscontact,
            "year": a.applicantsyear,
            "course": a.applicantscourse,
            "branch": a.applicantsbranch,
            "resume": a.applicantsresume.url if a.applicantsresume else ""
        })

    return JsonResponse(data, safe=False)